/*
 * Decompiled with CFR 0.152.
 */
package net.sf.foxon;

public class Reformat {
    public static final char LF = '\n';
    public static final char SPC = ' ';
    public static final char ZWS = '\u200b';

    private Reformat() {
    }

    public static boolean isXMLWhitespace(char ch) {
        return ch == '\t' || ch == '\n' || ch == '\r' || ch == ' ';
    }

    public static boolean isFOWhitespace(char ch) {
        return Reformat.isXMLWhitespace(ch) && ch != '\n';
    }

    public static char[] charArraySlice(char[] chars, int start, int len) {
        char[] result = new char[len];
        int i = start;
        int j = 0;
        while (j < len) {
            result[j] = chars[i];
            ++i;
            ++j;
        }
        return result;
    }

    public static String lf_as_space(String s) {
        char[] ch = s.toCharArray();
        int i = 0;
        while (i < ch.length) {
            if (ch[i] == '\n') {
                ch[i] = 32;
            }
            ++i;
        }
        return ch.toString();
    }

    public static String lf_as_0space(String s) {
        char[] ch = s.toCharArray();
        int i = 0;
        while (i < ch.length) {
            if (ch[i] == '\n') {
                ch[i] = 8203;
            }
            ++i;
        }
        return ch.toString();
    }

    public static String lf_ignore(String s) {
        int slen = s.length();
        StringBuffer buf = new StringBuffer(slen);
        int i = 0;
        while (i < slen) {
            char k = s.charAt(i);
            if (k != '\n') {
                buf.append(k);
            }
            ++i;
        }
        return buf.toString();
    }

    public static char[] ws_ignore(char[] chars, int start, int len) {
        char[] temp = new char[len];
        int copied = 0;
        int end = start + len;
        int i = start;
        while (i < end) {
            char k = chars[i];
            if (!Reformat.isFOWhitespace(k)) {
                temp[copied++] = k;
            }
            ++i;
        }
        return Reformat.charArraySlice(temp, 0, copied);
    }

    public static char[] ws_preserve(char[] chars, int start, int len) {
        char[] result = new char[len];
        int i = start;
        int j = 0;
        while (j < len) {
            int k = chars[i];
            result[j] = Reformat.isFOWhitespace((char)k) ? 32 : k;
            ++i;
            ++j;
        }
        return result;
    }

    public static char[] ws_ignore_before_lf(char[] chars, int start, int len) {
        char[] temp = new char[len];
        int copied = 0;
        int end = start + len;
        int i = start;
        while (i < end) {
            int k = chars[i];
            if (k == 10) {
                while (copied > 0 && Reformat.isFOWhitespace(temp[copied - 1])) {
                    --copied;
                }
            }
            temp[copied++] = Reformat.isFOWhitespace((char)k) ? 32 : k;
            ++i;
        }
        return Reformat.charArraySlice(temp, 0, copied);
    }

    public static char[] ws_ignore_after_lf(char[] chars, int start, int len) {
        char[] temp = new char[len];
        int copied = 0;
        int end = start + len;
        int last = end - 1;
        int i = start;
        while (i < end) {
            int k = chars[i];
            int n = temp[copied++] = Reformat.isFOWhitespace((char)k) ? 32 : k;
            if (k == 10) {
                while (i < last && Reformat.isFOWhitespace(chars[i + 1])) {
                    ++i;
                }
            }
            ++i;
        }
        return Reformat.charArraySlice(temp, 0, copied);
    }

    public static char[] ws_ignore_surrounding_lf(char[] chars, int start, int len) {
        char[] temp = new char[len];
        int copied = 0;
        int end = start + len;
        int last = end - 1;
        int i = start;
        while (i < end) {
            int k = chars[i];
            if (k == 10) {
                while (copied > 0 && Reformat.isFOWhitespace(temp[copied - 1])) {
                    --copied;
                }
            }
            int n = temp[copied++] = Reformat.isFOWhitespace((char)k) ? 32 : k;
            if (k == 10) {
                while (i < last && Reformat.isFOWhitespace(chars[i + 1])) {
                    ++i;
                }
            }
            ++i;
        }
        return Reformat.charArraySlice(temp, 0, copied);
    }

    public static char[] ws_collapse(char[] chars, int start, int len) {
        char[] temp = new char[len];
        int copied = 0;
        int end = start + len;
        int last = end - 1;
        int i = start;
        while (i < end) {
            char k = chars[i];
            if (k == '\n') {
                while (copied > 0 && Reformat.isFOWhitespace(temp[copied - 1])) {
                    --copied;
                }
            }
            char c = temp[copied++] = Reformat.isFOWhitespace(k) ? (char)' ' : k;
            if (Reformat.isXMLWhitespace(k)) {
                while (i < last && Reformat.isFOWhitespace(chars[i + 1])) {
                    ++i;
                }
            }
            ++i;
        }
        return Reformat.charArraySlice(temp, 0, copied);
    }

    public static char[] defaultReformat(char[] chars, int start, int len) {
        char[] temp = new char[len];
        int copied = 0;
        int end = start + len;
        int last = end - 1;
        int i = start;
        while (i < end) {
            char k = chars[i];
            if (Reformat.isXMLWhitespace(k)) {
                temp[copied++] = 32;
                while (i < last && Reformat.isXMLWhitespace(chars[i + 1])) {
                    ++i;
                }
            } else {
                temp[copied++] = k;
            }
            ++i;
        }
        return Reformat.charArraySlice(temp, 0, copied);
    }

    public static char[][] defaultReformatChunks(char[] chars, int start, int len) {
        char[][] chunks = new char[len / 2 + 1][];
        int chunk = 0;
        int chunklen = 0;
        int end = start + len;
        int last = end - 1;
        int i = start;
        while (i < end) {
            char k = chars[i];
            boolean finalizeChunk = false;
            if (Reformat.isXMLWhitespace(k)) {
                finalizeChunk = true;
                while (i < last && Reformat.isXMLWhitespace(chars[i + 1])) {
                    ++i;
                }
            } else {
                if (chunks[chunk] == null) {
                    chunks[chunk] = new char[end - i];
                    chunklen = 0;
                }
                chunks[chunk][chunklen++] = k;
                boolean bl = finalizeChunk = i == last;
            }
            if (finalizeChunk && chunklen > 0) {
                chunks[chunk] = Reformat.charArraySlice(chunks[chunk], 0, chunklen);
                ++chunk;
            }
            ++i;
        }
        char[][] result = new char[chunk][];
        int i2 = 0;
        while (i2 < chunk) {
            result[i2] = chunks[i2];
            ++i2;
        }
        return result;
    }
}

