/*
 * Decompiled with CFR 0.152.
 */
package net.sf.foxon;

import com.icl.saxon.output.XMLEmitter;
import com.icl.saxon.sort.HashMap;
import java.io.IOException;
import java.util.BitSet;
import javax.xml.transform.TransformerException;
import net.sf.foxon.Reformat;
import org.xml.sax.Attributes;

public class FOIndenter
extends XMLEmitter {
    static boolean[] specialInText = new boolean[128];
    static boolean[] specialInAtt;
    protected int linePos = 0;
    protected int lineLength = 72;
    private int indentSpaces = 3;
    private int nestingLevel = 0;
    private int indentLevel = 0;
    private BitSet indentLevelRaised = new BitSet();
    protected int preformatLevel = Integer.MAX_VALUE;
    protected int leftmostStarttagLevel = Integer.MAX_VALUE;
    private String indentChars = "                                                          ";
    private boolean afterTag = true;
    private boolean lastTagInline = false;
    private static String[] inlinesArray;
    private static HashMap inlinesHashMap;
    char[] attbuff1 = new char[256];
    private char[] charref = new char[10];

    static {
        int i = 0;
        while (i <= 127) {
            FOIndenter.specialInText[i] = false;
            ++i;
        }
        FOIndenter.specialInText[13] = true;
        FOIndenter.specialInText[60] = true;
        FOIndenter.specialInText[62] = true;
        FOIndenter.specialInText[38] = true;
        specialInAtt = new boolean[128];
        i = 0;
        while (i <= 127) {
            FOIndenter.specialInAtt[i] = false;
            ++i;
        }
        FOIndenter.specialInAtt[13] = true;
        FOIndenter.specialInAtt[10] = true;
        FOIndenter.specialInAtt[60] = true;
        FOIndenter.specialInAtt[62] = true;
        FOIndenter.specialInAtt[38] = true;
        FOIndenter.specialInAtt[34] = true;
        inlinesArray = new String[]{"fo:character", "fo:external-graphic", "fo:instream-foreign-object", "fo:inline", "fo:leader", "fo:page-number", "fo:page-number-citation", "fo:basic-link", "fo:multi-toggle", "fo:wrapper", "fo:marker", "fo:retrieve-marker"};
        inlinesHashMap = new HashMap(4 * inlinesArray.length);
        int j = 0;
        while (j < inlinesArray.length) {
            inlinesHashMap.set(inlinesArray[j]);
            ++j;
        }
    }

    private static boolean isInline(String element) {
        return inlinesHashMap.get(element);
    }

    private boolean isInline(int tag) {
        return FOIndenter.isInline(this.namePool.getDisplayName(tag));
    }

    public static boolean isPreformattedElement(String name, Attributes atts) {
        return name.equalsIgnoreCase("fo:block") && ("preserve".equalsIgnoreCase(atts.getValue("linefeed-treatment")) || "preserve".equalsIgnoreCase(atts.getValue("white-space-treatment")) || "false".equalsIgnoreCase(atts.getValue("white-space-collapse")));
    }

    public boolean isPreformattedElement(int tag, Attributes atts) {
        return FOIndenter.isPreformattedElement(this.namePool.getDisplayName(tag), atts);
    }

    public void startElement(int tag, Attributes atts, int[] namespaces, int nscount) throws TransformerException {
        boolean doIndent;
        if (this.openStartTag) {
            this.closeStartTag(-1, false);
        }
        String strTag = this.namePool.getDisplayName(tag);
        boolean thisInline = FOIndenter.isInline(strTag);
        boolean inPreformatted = this.nestingLevel >= this.preformatLevel;
        boolean bl = doIndent = this.afterTag && !inPreformatted && !thisInline;
        if (doIndent) {
            this.indent();
        }
        this.writeStarttag(tag, atts, namespaces, nscount, !thisInline);
        if (doIndent) {
            ++this.indentLevel;
        }
        this.indentLevelRaised.set(++this.nestingLevel, doIndent);
        this.afterTag = true;
        this.lastTagInline = thisInline;
        if (this.preformatLevel > this.nestingLevel && FOIndenter.isPreformattedElement(strTag, atts)) {
            this.preformatLevel = this.nestingLevel;
        }
        if (this.leftmostStarttagLevel > this.nestingLevel) {
            this.leftmostStarttagLevel = this.nestingLevel;
        }
    }

    public void endElement(int tag) throws TransformerException {
        boolean thisPreformatted;
        boolean closed_as_empty = false;
        if (this.openStartTag) {
            this.closeStartTag(tag, true);
            closed_as_empty = true;
        }
        boolean startOnSameLine = this.nestingLevel >= this.leftmostStarttagLevel;
        boolean bl = thisPreformatted = this.nestingLevel >= this.preformatLevel;
        if (this.indentLevelRaised.get(this.nestingLevel--)) {
            --this.indentLevel;
            if (!(!this.afterTag || this.lastTagInline || startOnSameLine || thisPreformatted || closed_as_empty)) {
                this.indent();
            }
        }
        if (!closed_as_empty) {
            this.writeEndtag(tag);
        }
        this.afterTag = true;
        this.lastTagInline = this.isInline(tag);
        if (this.nestingLevel < this.preformatLevel) {
            this.preformatLevel = Integer.MAX_VALUE;
        }
    }

    public void characters(char[] chars, int start, int len) throws TransformerException {
        boolean inPreformatted;
        if (this.openStartTag) {
            this.closeStartTag(-1, false);
        }
        int end = start + len;
        boolean containsNonWs = false;
        boolean bl = inPreformatted = this.nestingLevel >= this.preformatLevel;
        if (!inPreformatted) {
            int i = start;
            while (i < end) {
                int chunkstart = i;
                boolean spacePending = false;
                while (i < end && Reformat.isXMLWhitespace(chars[i])) {
                    spacePending = true;
                    ++i;
                }
                if (spacePending) {
                    chars[i - 1] = 32;
                    chunkstart = i - 1;
                }
                while (i < end && !Reformat.isXMLWhitespace(chars[i])) {
                    containsNonWs = true;
                    ++i;
                }
                int chunkend = i;
                int chunklen = chunkend - chunkstart;
                if (chunklen > 0) {
                    if (this.linePos + chunklen > this.lineLength && spacePending) {
                        this.indent();
                        ++chunkstart;
                        --chunklen;
                    }
                    this.writeCharacters(chars, chunkstart, chunklen);
                }
                --i;
                ++i;
            }
        } else {
            int i = start;
            while (i < end) {
                if (chars[i] == '\n') {
                    this.leftmostStarttagLevel = Integer.MAX_VALUE;
                } else if (!Reformat.isXMLWhitespace(chars[i])) {
                    containsNonWs = true;
                }
                if (containsNonWs && this.leftmostStarttagLevel == Integer.MAX_VALUE) break;
                ++i;
            }
            this.writeCharacters(chars, start, len);
        }
        if (containsNonWs) {
            this.afterTag = false;
        }
    }

    public void writeCharacters(char[] ch, int start, int len) throws TransformerException {
        try {
            if (!this.escaping) {
                if (this.testCharacters(ch, start, len)) {
                    this.writer.write(ch, start, len);
                    this.linePos += len;
                } else {
                    this.writeEscape(ch, start, len, false);
                }
            } else {
                this.writeEscape(ch, start, len, false);
            }
        }
        catch (IOException err) {
            throw new TransformerException(err);
        }
    }

    private void indent() throws TransformerException {
        try {
            int spaces = this.indentLevel * this.indentSpaces;
            while (spaces > this.indentChars.length()) {
                this.indentChars = String.valueOf(this.indentChars) + this.indentChars;
            }
            this.writer.write(10);
            this.writer.write(this.indentChars, 0, spaces);
            this.linePos = 0;
            this.leftmostStarttagLevel = Integer.MAX_VALUE;
        }
        catch (IOException err) {
            throw new TransformerException(err);
        }
    }

    protected void writeStarttag(int nameCode, Attributes attributes, int[] namespaces, int nscount, boolean alignAttrs) throws TransformerException {
        String displayName;
        String uri;
        String prefix;
        if (nameCode == this.lastNameCode) {
            prefix = this.lastPrefix;
            uri = this.lastURI;
            displayName = this.lastDisplayName;
        } else {
            prefix = this.namePool.getPrefix(nameCode);
            uri = this.namePool.getURI(nameCode);
            displayName = this.namePool.getDisplayName(nameCode);
            this.lastNameCode = nameCode;
            this.lastDisplayName = displayName;
            this.lastPrefix = prefix;
            this.lastURI = uri;
        }
        try {
            if (this.empty) {
                String systemId = this.outputProperties.getProperty("doctype-system");
                String publicId = this.outputProperties.getProperty("doctype-public");
                if (systemId != null) {
                    this.writeDocType(displayName, systemId, publicId);
                }
                this.empty = false;
            }
            this.writer.write(60);
            this.testCharacters(displayName);
            this.writer.write(displayName);
            this.linePos += displayName.length() + 1;
            int attrExtraIndent = displayName.length() + 2;
            String attrExtraIndentString = "";
            int i = 0;
            while (alignAttrs && i < attrExtraIndent) {
                attrExtraIndentString = String.valueOf(attrExtraIndentString) + ' ';
                ++i;
            }
            int attrsWritten = 0;
            int n = 0;
            while (n < nscount) {
                boolean stayOnLine;
                String nsPrefix = this.namePool.getPrefixFromNamespaceCode(namespaces[n]);
                String nsUri = this.namePool.getURIFromNamespaceCode(namespaces[n]);
                String attrName = nsPrefix.equals("") ? "xmlns" : "xmlns:" + nsPrefix;
                int len = attrName.length() + nsUri.length() + 4;
                int endpos = this.linePos + len;
                boolean bl = stayOnLine = this.linePos == 0 || alignAttrs && attrsWritten == 0;
                if (endpos > this.lineLength && !stayOnLine) {
                    this.indent();
                    if (alignAttrs) {
                        this.writer.write(attrExtraIndentString);
                        this.linePos += attrExtraIndent;
                    }
                } else {
                    this.writer.write(32);
                    ++this.linePos;
                }
                this.writeAttribute(nameCode, attrName, "CDATA", nsUri);
                ++attrsWritten;
                ++n;
            }
            int numAttrs = attributes.getLength();
            int i2 = 0;
            while (i2 < numAttrs) {
                boolean stayOnLine;
                String attrName = attributes.getQName(i2);
                String attrType = attributes.getType(i2);
                String attrValue = attributes.getValue(i2);
                int len = attrName.length() + attrValue.length() + 4;
                int endpos = this.linePos + len;
                boolean bl = stayOnLine = this.linePos == 0 || alignAttrs && attrsWritten == 0;
                if (endpos > this.lineLength && !stayOnLine) {
                    this.indent();
                    if (alignAttrs) {
                        this.writer.write(attrExtraIndentString);
                        this.linePos += attrExtraIndent;
                    }
                } else {
                    this.writer.write(32);
                    ++this.linePos;
                }
                this.writeAttribute(nameCode, attrName, attrType, attrValue);
                ++attrsWritten;
                ++i2;
            }
            this.openStartTag = true;
        }
        catch (IOException err) {
            throw new TransformerException(err);
        }
    }

    protected void closeStartTag(int nameCode, boolean emptyTag) throws TransformerException {
        try {
            if (this.openStartTag) {
                if (emptyTag) {
                    String tagCloser = this.emptyElementTagCloser(nameCode);
                    this.writer.write(tagCloser);
                    this.linePos += tagCloser.length();
                } else {
                    this.writer.write(62);
                    ++this.linePos;
                }
                this.openStartTag = false;
            }
        }
        catch (IOException err) {
            throw new TransformerException(err);
        }
    }

    public void writeEndtag(int nameCode) throws TransformerException {
        try {
            String displayName = nameCode == this.lastNameCode ? this.lastDisplayName : this.namePool.getDisplayName(nameCode);
            this.writer.write("</");
            this.writer.write(displayName);
            this.writer.write(62);
            this.linePos += displayName.length() + 3;
        }
        catch (IOException err) {
            throw new TransformerException(err);
        }
    }

    protected void writeAttribute(int elCode, String attname, String type, String value) throws TransformerException {
        try {
            this.testCharacters(attname);
            this.writer.write(attname);
            this.writer.write("=\"");
            this.linePos += attname.length() + 2;
            int len = value.length();
            if (type.equals("NO-ESC")) {
                this.writer.write(value);
                int iLineBreak = Math.max(value.lastIndexOf(10), value.lastIndexOf(13));
                this.linePos = iLineBreak < 0 ? (this.linePos += len) : len - (iLineBreak + 1);
            } else {
                if (len > this.attbuff1.length) {
                    this.attbuff1 = new char[len];
                }
                value.getChars(0, len, this.attbuff1, 0);
                this.writeEscape(this.attbuff1, 0, len, true);
            }
            this.writer.write(34);
            ++this.linePos;
        }
        catch (IOException err) {
            throw new TransformerException(err);
        }
    }

    protected void outputCharacterReference(int charval) throws IOException {
        int len = 0;
        this.charref[len++] = 38;
        this.charref[len++] = 35;
        if (this.preferHex) {
            this.charref[len++] = 120;
        }
        String code = this.preferHex ? Integer.toHexString(charval) : Integer.toString(charval);
        int codelen = code.length();
        int k = 0;
        while (k < codelen) {
            this.charref[len++] = code.charAt(k);
            ++k;
        }
        this.charref[len++] = 59;
        this.writer.write(this.charref, 0, len);
        this.linePos += len;
    }

    protected void writeEscape(char[] ch, int start, int length, boolean inAttribute) throws IOException {
        int segstart = start;
        boolean[] specialChars = inAttribute ? specialInAtt : specialInText;
        while (segstart < start + length) {
            int i = segstart;
            int iOnNewLine = -1;
            while (i < start + length && !(ch[i] < '\u0080' ? specialChars[ch[i]] : !this.characterSet.inCharset((int)ch[i]))) {
                if (ch[i] == '\n' || ch[i] == '\r') {
                    iOnNewLine = i + 1;
                }
                ++i;
            }
            int len = i - segstart;
            this.writer.write(ch, segstart, len);
            this.linePos = iOnNewLine < 0 ? (this.linePos += len) : i - iOnNewLine;
            if (i >= start + length) {
                return;
            }
            int k = ch[i];
            if (k > 127) {
                int charval;
                if (k >= 55296 && k <= 56319) {
                    charval = (k - 55296) * 1024 + (ch[i + 1] - 56320) + 65536;
                    ++i;
                } else {
                    charval = k;
                }
                this.outputCharacterReference(charval);
            } else {
                String ref = "";
                switch (k) {
                    case 60: {
                        ref = "&lt;";
                        break;
                    }
                    case 62: {
                        ref = "&gt;";
                        break;
                    }
                    case 38: {
                        ref = "&amp;";
                        break;
                    }
                    case 34: {
                        ref = "&#34;";
                        break;
                    }
                    case 10: {
                        ref = "&#xA;";
                        break;
                    }
                    case 13: {
                        ref = "&#xD;";
                    }
                }
                this.writer.write(ref);
                this.linePos += ref.length();
            }
            segstart = ++i;
        }
    }

    public void startDocument() throws TransformerException {
        String omit;
        super.startDocument();
        String s = this.outputProperties.getProperty("{http://icl.com/saxon}indent-spaces");
        if (s != null) {
            try {
                this.indentSpaces = Integer.parseInt(s);
            }
            catch (Exception err) {
                this.indentSpaces = 3;
            }
        }
        this.afterTag = (omit = this.outputProperties.getProperty("omit-xml-declaration")) == null || !omit.equals("yes") || this.outputProperties.getProperty("doctype-system") != null;
    }

    public void processingInstruction(String target, String data) throws TransformerException {
        super.processingInstruction(target, data);
        this.afterTag = true;
    }

    public void ignorableWhitespace(char[] chars, int start, int len) throws TransformerException {
    }

    public void comment(char[] chars, int start, int len) throws TransformerException {
        super.comment(chars, start, len);
        this.afterTag = true;
    }

    public void endDocument() throws TransformerException {
        super.endDocument();
    }
}

