/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.util;

public class CharUtilities {
    public static final char CODE_EOT = '\u0000';
    public static final int UCWHITESPACE = 0;
    public static final int LINEFEED = 1;
    public static final int EOT = 2;
    public static final int NONWHITESPACE = 3;
    public static final int XMLWHITESPACE = 4;
    public static final char SPACE = ' ';
    public static final char NBSPACE = '\u00a0';
    public static final char ZERO_WIDTH_SPACE = '\u200b';
    public static final char ZERO_WIDTH_NOBREAK_SPACE = '\ufeff';
    public static final char SOFT_HYPHEN = '\u00ad';

    protected CharUtilities() {
        throw new UnsupportedOperationException();
    }

    public static int classOf(char c) {
        if (c == '\u0000') {
            return 2;
        }
        if (c == '\n') {
            return 1;
        }
        if (c == ' ' || c == '\r' || c == '\t') {
            return 4;
        }
        if (CharUtilities.isAnySpace(c)) {
            return 0;
        }
        return 3;
    }

    public static boolean isBreakableSpace(char c) {
        return c == ' ' || CharUtilities.isFixedWidthSpace(c);
    }

    public static boolean isZeroWidthSpace(char c) {
        return c == '\u200b' || c == '\ufeff';
    }

    public static boolean isFixedWidthSpace(char c) {
        return c >= '\u2000' && c <= '\u200b' || c == '\u3000';
    }

    public static boolean isNonBreakableSpace(char c) {
        return c == '\u00a0' || c == '\u202f' || c == '\u3000' || c == '\ufeff';
    }

    public static boolean isAdjustableSpace(char c) {
        return c == ' ' || c == '\u00a0';
    }

    public static boolean isAnySpace(char c) {
        boolean ret = CharUtilities.isBreakableSpace(c) || CharUtilities.isNonBreakableSpace(c);
        return ret;
    }

    public static boolean isAlphabetic(char ch) {
        int generalCategory = Character.getType(ch);
        switch (generalCategory) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 10: {
                return true;
            }
        }
        return false;
    }
}

