/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import org.apache.fop.area.DestinationData;
import org.apache.fop.area.PageViewport;
import org.apache.fop.pdf.PDFObject;

public class PDFDestination
extends PDFObject {
    private String goToReference;
    private String idRef;
    private PageViewport pageViewport = null;

    public PDFDestination(DestinationData destinationData) {
        this.goToReference = destinationData.getGoToReference();
        this.idRef = destinationData.getIDRef();
        this.pageViewport = destinationData.getPageViewport();
    }

    public PDFDestination(String idRef, String goToRef, PageViewport pv) {
        this.idRef = idRef;
        this.goToReference = goToRef;
        this.pageViewport = pv;
    }

    public String toPDFString() {
        String s = this.getObjectID() + "<<\n" + "/Limits [(" + this.idRef + ") (" + this.idRef + ")]\n" + "/Names [(" + this.idRef + ") " + this.goToReference + "]" + "\n>>\nendobj\n";
        return s;
    }

    public void setGoToReference(String goToReference) {
        this.goToReference = goToReference;
    }

    public String getGoToReference() {
        return this.goToReference;
    }

    public PageViewport getPageViewport() {
        return this.pageViewport;
    }

    public String getIDRef() {
        return this.idRef;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof PDFDestination)) {
            return false;
        }
        PDFDestination dest = (PDFDestination)obj;
        return dest.getIDRef().equals(this.getIDRef());
    }
}

