/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr.table;

import java.util.LinkedList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.area.Area;
import org.apache.fop.area.Block;
import org.apache.fop.area.Trait;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.flow.Table;
import org.apache.fop.fo.flow.TableCell;
import org.apache.fop.fo.properties.CommonBorderPaddingBackground;
import org.apache.fop.layoutmgr.AreaAdditionUtil;
import org.apache.fop.layoutmgr.BlockLevelLayoutManager;
import org.apache.fop.layoutmgr.BlockStackingLayoutManager;
import org.apache.fop.layoutmgr.BreakElement;
import org.apache.fop.layoutmgr.KnuthElement;
import org.apache.fop.layoutmgr.KnuthGlue;
import org.apache.fop.layoutmgr.LayoutContext;
import org.apache.fop.layoutmgr.ListElement;
import org.apache.fop.layoutmgr.Position;
import org.apache.fop.layoutmgr.PositionIterator;
import org.apache.fop.layoutmgr.SpaceResolver;
import org.apache.fop.layoutmgr.TraitSetter;
import org.apache.fop.layoutmgr.table.GridUnit;
import org.apache.fop.layoutmgr.table.PrimaryGridUnit;
import org.apache.fop.layoutmgr.table.TableLayoutManager;
import org.apache.fop.traits.MinOptMax;

public class TableCellLayoutManager
extends BlockStackingLayoutManager
implements BlockLevelLayoutManager {
    private static Log log = LogFactory.getLog((Class)(class$org$apache$fop$layoutmgr$table$TableCellLayoutManager == null ? (class$org$apache$fop$layoutmgr$table$TableCellLayoutManager = TableCellLayoutManager.class$("org.apache.fop.layoutmgr.table.TableCellLayoutManager")) : class$org$apache$fop$layoutmgr$table$TableCellLayoutManager));
    private PrimaryGridUnit primaryGridUnit;
    private Block curBlockArea;
    private int inRowIPDOffset;
    private int xoffset;
    private int yoffset;
    private int cellIPD;
    private int rowHeight;
    private int usedBPD;
    private int startBorderWidth;
    private int endBorderWidth;
    private int borderAndPaddingBPD;
    private boolean emptyCell = true;
    static /* synthetic */ Class class$org$apache$fop$layoutmgr$table$TableCellLayoutManager;

    public TableCellLayoutManager(TableCell node, PrimaryGridUnit pgu) {
        super(node);
        this.fobj = node;
        this.primaryGridUnit = pgu;
    }

    public TableCell getTableCell() {
        return (TableCell)this.fobj;
    }

    private boolean isSeparateBorderModel() {
        return this.getTable().isSeparateBorderModel();
    }

    public void initialize() {
        this.borderAndPaddingBPD = 0;
        this.borderAndPaddingBPD += this.getTableCell().getCommonBorderPaddingBackground().getBorderBeforeWidth(false);
        this.borderAndPaddingBPD += this.getTableCell().getCommonBorderPaddingBackground().getBorderAfterWidth(false);
        if (!this.isSeparateBorderModel()) {
            this.borderAndPaddingBPD /= 2;
        }
        this.borderAndPaddingBPD += this.getTableCell().getCommonBorderPaddingBackground().getPaddingBefore(false, this);
        this.borderAndPaddingBPD += this.getTableCell().getCommonBorderPaddingBackground().getPaddingAfter(false, this);
    }

    public Table getTable() {
        FONode node = this.fobj.getParent();
        while (!(node instanceof Table)) {
            node = node.getParent();
        }
        return (Table)node;
    }

    protected int getIPIndents() {
        int iIndents = 0;
        int[] startEndBorderWidths = this.primaryGridUnit.getStartEndBorderWidths();
        this.startBorderWidth += startEndBorderWidths[0];
        this.endBorderWidth += startEndBorderWidths[1];
        iIndents += this.startBorderWidth;
        iIndents += this.endBorderWidth;
        if (!this.isSeparateBorderModel()) {
            iIndents /= 2;
        }
        iIndents += this.getTableCell().getCommonBorderPaddingBackground().getPaddingStart(false, this);
        return iIndents += this.getTableCell().getCommonBorderPaddingBackground().getPaddingEnd(false, this);
    }

    public LinkedList getNextKnuthElements(LayoutContext context, int alignment) {
        BlockLevelLayoutManager curLM;
        MinOptMax stackLimit = new MinOptMax(context.getStackLimit());
        this.cellIPD = this.referenceIPD = context.getRefIPD();
        this.cellIPD -= this.getIPIndents();
        if (this.isSeparateBorderModel()) {
            int borderSep = this.getTable().getBorderSeparation().getLengthPair().getIPD().getLength().getValue(this);
            this.cellIPD -= borderSep;
        }
        LinkedList returnedList = null;
        LinkedList contentList = new LinkedList();
        LinkedList returnList = new LinkedList();
        BlockLevelLayoutManager prevLM = null;
        while ((curLM = (BlockLevelLayoutManager)this.getChildLM()) != null) {
            LayoutContext childLC = new LayoutContext(0);
            childLC.setStackLimit(MinOptMax.subtract(context.getStackLimit(), stackLimit));
            childLC.setRefIPD(this.cellIPD);
            returnedList = curLM.getNextKnuthElements(childLC, alignment);
            if (childLC.isKeepWithNextPending()) {
                log.debug((Object)"child LM signals pending keep with next");
            }
            if (contentList.size() == 0 && childLC.isKeepWithPreviousPending()) {
                context.setFlags(1024);
                childLC.setFlags(1024, false);
            }
            if (returnedList.size() == 1 && ((ListElement)returnedList.getFirst()).isForcedBreak()) {
                if (returnList.size() == 0) {
                    // empty if block
                }
                contentList.addAll(returnedList);
                returnedList = new LinkedList();
                this.wrapPositionElements(contentList, returnList);
                SpaceResolver.resolveElementList(returnList);
                return returnList;
            }
            if (prevLM != null) {
                if (this.mustKeepTogether() || context.isKeepWithNextPending() || childLC.isKeepWithPreviousPending()) {
                    context.setFlags(512, false);
                    childLC.setFlags(1024, false);
                    contentList.add(new BreakElement(new Position(this), 1000, context));
                } else if (!((ListElement)contentList.getLast()).isGlue()) {
                    contentList.add(new BreakElement(new Position(this), 0, context));
                }
            }
            contentList.addAll(returnedList);
            if (returnedList.size() == 0) continue;
            if (((ListElement)returnedList.getLast()).isForcedBreak()) {
                if (curLM.isFinished()) {
                    this.setFinished(true);
                }
                returnedList = new LinkedList();
                this.wrapPositionElements(contentList, returnList);
                SpaceResolver.resolveElementList(returnList);
                return returnList;
            }
            if (childLC.isKeepWithNextPending()) {
                childLC.setFlags(512, false);
                context.setFlags(512);
            }
            prevLM = curLM;
        }
        returnedList = new LinkedList();
        this.wrapPositionElements(contentList, returnList);
        SpaceResolver.resolveElementList(returnList);
        this.getPSLM().notifyEndOfLayout(((TableCell)this.getFObj()).getId());
        this.setFinished(true);
        return returnList;
    }

    public void setYOffset(int off) {
        this.yoffset = off;
    }

    public void setXOffset(int off) {
        this.xoffset = off;
    }

    public void setInRowIPDOffset(int off) {
        this.inRowIPDOffset = off;
    }

    public void setContentHeight(int h) {
        this.usedBPD = h;
    }

    public void setRowHeight(int h) {
        this.rowHeight = h;
    }

    private int getContentHeight(GridUnit gu) {
        int bpd = this.rowHeight;
        if (this.isSeparateBorderModel()) {
            bpd -= gu.getPrimary().getBorders().getBorderBeforeWidth(false);
            bpd -= gu.getPrimary().getBorders().getBorderAfterWidth(false);
        } else {
            bpd -= gu.getPrimary().getHalfMaxBorderWidth();
        }
        CommonBorderPaddingBackground cbpb = gu.getCell().getCommonBorderPaddingBackground();
        bpd -= cbpb.getPaddingBefore(false, this);
        bpd -= cbpb.getPaddingAfter(false, this);
        return bpd -= 2 * ((TableLayoutManager)this.getParent()).getHalfBorderSeparationBPD();
    }

    public void addAreas(PositionIterator parentIter, LayoutContext layoutContext, int[] spannedGridRowHeights, int startRow, int endRow) {
        int contentBPD;
        boolean[] outer;
        this.getParentArea(null);
        this.getPSLM().addIDToPage(this.getTableCell().getId());
        if (this.isSeparateBorderModel()) {
            if (!this.emptyCell || this.getTableCell().showEmptyCells()) {
                TraitSetter.addBorders(this.curBlockArea, this.getTableCell().getCommonBorderPaddingBackground(), false, false, false, false, this);
                TraitSetter.addPadding(this.curBlockArea, this.getTableCell().getCommonBorderPaddingBackground(), false, false, false, false, this);
            }
        } else if (!this.primaryGridUnit.hasSpanning()) {
            outer = new boolean[]{this.primaryGridUnit.getFlag(2), this.primaryGridUnit.getFlag(5), this.primaryGridUnit.getFlag(0), this.primaryGridUnit.getFlag(1)};
            TraitSetter.addCollapsingBorders(this.curBlockArea, this.primaryGridUnit.getBorders(), outer, this);
        } else {
            outer = new boolean[4];
            int dy = this.yoffset;
            for (int y = startRow; y < endRow; ++y) {
                GridUnit[] gridUnits = (GridUnit[])this.primaryGridUnit.getRows().get(y);
                int dx = this.xoffset;
                for (int x = 0; x < gridUnits.length; ++x) {
                    GridUnit gu = gridUnits[x];
                    if (!gu.hasBorders()) continue;
                    Block block = new Block();
                    block.addTrait(Trait.IS_REFERENCE_AREA, Boolean.TRUE);
                    block.setPositioning(2);
                    int bpd = spannedGridRowHeights[y - startRow];
                    bpd -= gu.getBorders().getBorderBeforeWidth(false) / 2;
                    block.setBPD(bpd -= gu.getBorders().getBorderAfterWidth(false) / 2);
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("pgu: " + this.primaryGridUnit + "; gu: " + gu + "; yoffset: " + (dy - gu.getBorders().getBorderBeforeWidth(false) / 2) + "; bpd: " + bpd));
                    }
                    int ipd = gu.getColumn().getColumnWidth().getValue(this.getParent());
                    int borderStartWidth = gu.getBorders().getBorderStartWidth(false) / 2;
                    ipd -= borderStartWidth;
                    block.setIPD(ipd -= gu.getBorders().getBorderEndWidth(false) / 2);
                    block.setXOffset(dx + borderStartWidth);
                    block.setYOffset(dy - gu.getBorders().getBorderBeforeWidth(false) / 2);
                    outer[0] = gu.getFlag(2);
                    outer[1] = gu.getFlag(5);
                    outer[2] = gu.getFlag(0);
                    outer[3] = gu.getFlag(1);
                    TraitSetter.addCollapsingBorders(block, gu.getBorders(), outer, this);
                    this.parentLM.addChildArea(block);
                    dx += gu.getColumn().getColumnWidth().getValue(this.getParent());
                }
                dy += spannedGridRowHeights[y - startRow];
            }
        }
        if (this.usedBPD < (contentBPD = this.getContentHeight(this.primaryGridUnit))) {
            if (this.getTableCell().getDisplayAlign() == 23) {
                Block space = new Block();
                space.setBPD((contentBPD - this.usedBPD) / 2);
                this.curBlockArea.addBlock(space);
            } else if (this.getTableCell().getDisplayAlign() == 3) {
                Block space = new Block();
                space.setBPD(contentBPD - this.usedBPD);
                this.curBlockArea.addBlock(space);
            }
        }
        AreaAdditionUtil.addAreas(this, parentIter, layoutContext);
        this.curBlockArea.setBPD(contentBPD);
        if (this.isSeparateBorderModel()) {
            if (!this.emptyCell || this.getTableCell().showEmptyCells()) {
                TraitSetter.addBackground(this.curBlockArea, this.getTableCell().getCommonBorderPaddingBackground(), this);
            }
        } else {
            TraitSetter.addBackground(this.curBlockArea, this.getTableCell().getCommonBorderPaddingBackground(), this);
        }
        this.flush();
        this.curBlockArea = null;
    }

    public Area getParentArea(Area childArea) {
        if (this.curBlockArea == null) {
            this.curBlockArea = new Block();
            this.curBlockArea.addTrait(Trait.IS_REFERENCE_AREA, Boolean.TRUE);
            TraitSetter.setProducerID(this.curBlockArea, this.getTableCell().getId());
            this.curBlockArea.setPositioning(2);
            int indent = this.startBorderWidth;
            if (!this.isSeparateBorderModel()) {
                indent /= 2;
            }
            indent += this.getTableCell().getCommonBorderPaddingBackground().getPaddingStart(false, this);
            int borderAdjust = 0;
            if (!this.isSeparateBorderModel()) {
                borderAdjust = this.primaryGridUnit.hasSpanning() ? (borderAdjust -= this.primaryGridUnit.getHalfMaxBeforeBorderWidth()) : (borderAdjust += this.primaryGridUnit.getHalfMaxBeforeBorderWidth());
            }
            TableLayoutManager tableLM = (TableLayoutManager)this.getParent();
            this.curBlockArea.setXOffset(this.xoffset + this.inRowIPDOffset + tableLM.getHalfBorderSeparationIPD() + indent);
            this.curBlockArea.setYOffset(this.yoffset - borderAdjust + tableLM.getHalfBorderSeparationBPD());
            this.curBlockArea.setIPD(this.cellIPD);
            this.parentLM.getParentArea(this.curBlockArea);
            this.setCurrentArea(this.curBlockArea);
        }
        return this.curBlockArea;
    }

    public void addChildArea(Area childArea) {
        if (this.curBlockArea != null) {
            this.curBlockArea.addBlock((Block)childArea);
        }
    }

    public void resetPosition(Position resetPos) {
        if (resetPos == null) {
            this.reset(null);
        }
    }

    public int negotiateBPDAdjustment(int adj, KnuthElement lastElement) {
        return 0;
    }

    public void discardSpace(KnuthGlue spaceGlue) {
    }

    public boolean mustKeepTogether() {
        boolean keep = ((BlockLevelLayoutManager)this.getParent()).mustKeepTogether();
        if (this.primaryGridUnit.getRow() != null) {
            keep |= this.primaryGridUnit.getRow().mustKeepTogether();
        }
        return keep;
    }

    public boolean mustKeepWithPrevious() {
        return false;
    }

    public boolean mustKeepWithNext() {
        return false;
    }

    public int getContentAreaIPD() {
        return this.cellIPD;
    }

    public int getContentAreaBPD() {
        if (this.curBlockArea != null) {
            return this.curBlockArea.getBPD();
        }
        log.error((Object)"getContentAreaBPD called on unknown BPD");
        return -1;
    }

    public boolean getGeneratesReferenceArea() {
        return true;
    }

    public boolean getGeneratesBlockArea() {
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

