/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr.inline;

import org.apache.fop.area.LinkResolver;
import org.apache.fop.area.Trait;
import org.apache.fop.area.inline.InlineArea;
import org.apache.fop.datatypes.URISpecification;
import org.apache.fop.fo.flow.BasicLink;
import org.apache.fop.layoutmgr.LayoutManager;
import org.apache.fop.layoutmgr.PageSequenceLayoutManager;
import org.apache.fop.layoutmgr.inline.InlineLayoutManager;

public class BasicLinkLayoutManager
extends InlineLayoutManager {
    private BasicLink fobj;

    public BasicLinkLayoutManager(BasicLink node) {
        super(node);
        this.fobj = node;
    }

    protected InlineArea createArea(boolean bInlineParent) {
        InlineArea area = super.createArea(bInlineParent);
        this.setupBasicLinkArea(this.parentLM, area);
        return area;
    }

    private void setupBasicLinkArea(LayoutManager parentLM, InlineArea area) {
        String idref = this.fobj.getInternalDestination();
        if (idref != null && idref.length() > 0) {
            PageSequenceLayoutManager pslm = this.getPSLM();
            LinkResolver res = new LinkResolver(idref, area);
            res.resolveIDRef(idref, pslm.getFirstPVWithID(idref));
            if (!res.isResolved()) {
                pslm.addUnresolvedArea(idref, res);
            }
        } else {
            String url;
            String extdest = this.fobj.getExternalDestination();
            if (extdest != null && (url = URISpecification.getURL(extdest)).length() > 0) {
                area.addTrait(Trait.EXTERNAL_LINK, url);
            }
        }
    }
}

