/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.area.AreaTreeHandler;
import org.apache.fop.area.Block;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.FOText;
import org.apache.fop.fo.flow.BasicLink;
import org.apache.fop.fo.flow.BidiOverride;
import org.apache.fop.fo.flow.BlockContainer;
import org.apache.fop.fo.flow.Character;
import org.apache.fop.fo.flow.ExternalGraphic;
import org.apache.fop.fo.flow.Footnote;
import org.apache.fop.fo.flow.InlineContainer;
import org.apache.fop.fo.flow.InlineLevel;
import org.apache.fop.fo.flow.InstreamForeignObject;
import org.apache.fop.fo.flow.Leader;
import org.apache.fop.fo.flow.ListBlock;
import org.apache.fop.fo.flow.ListItem;
import org.apache.fop.fo.flow.PageNumber;
import org.apache.fop.fo.flow.PageNumberCitation;
import org.apache.fop.fo.flow.PageNumberCitationLast;
import org.apache.fop.fo.flow.Table;
import org.apache.fop.fo.flow.Wrapper;
import org.apache.fop.fo.pagination.Flow;
import org.apache.fop.fo.pagination.PageSequence;
import org.apache.fop.fo.pagination.SideRegion;
import org.apache.fop.fo.pagination.StaticContent;
import org.apache.fop.fo.pagination.Title;
import org.apache.fop.layoutmgr.BlockContainerLayoutManager;
import org.apache.fop.layoutmgr.BlockLayoutManager;
import org.apache.fop.layoutmgr.FlowLayoutManager;
import org.apache.fop.layoutmgr.LayoutManager;
import org.apache.fop.layoutmgr.LayoutManagerMaker;
import org.apache.fop.layoutmgr.PageSequenceLayoutManager;
import org.apache.fop.layoutmgr.StaticContentLayoutManager;
import org.apache.fop.layoutmgr.inline.BasicLinkLayoutManager;
import org.apache.fop.layoutmgr.inline.BidiLayoutManager;
import org.apache.fop.layoutmgr.inline.CharacterLayoutManager;
import org.apache.fop.layoutmgr.inline.ContentLayoutManager;
import org.apache.fop.layoutmgr.inline.ExternalGraphicLayoutManager;
import org.apache.fop.layoutmgr.inline.FootnoteLayoutManager;
import org.apache.fop.layoutmgr.inline.ICLayoutManager;
import org.apache.fop.layoutmgr.inline.InlineLayoutManager;
import org.apache.fop.layoutmgr.inline.InlineLevelLayoutManager;
import org.apache.fop.layoutmgr.inline.InstreamForeignObjectLM;
import org.apache.fop.layoutmgr.inline.LeaderLayoutManager;
import org.apache.fop.layoutmgr.inline.PageNumberCitationLastLayoutManager;
import org.apache.fop.layoutmgr.inline.PageNumberCitationLayoutManager;
import org.apache.fop.layoutmgr.inline.PageNumberLayoutManager;
import org.apache.fop.layoutmgr.inline.TextLayoutManager;
import org.apache.fop.layoutmgr.inline.WrapperLayoutManager;
import org.apache.fop.layoutmgr.list.ListBlockLayoutManager;
import org.apache.fop.layoutmgr.list.ListItemLayoutManager;
import org.apache.fop.layoutmgr.table.TableLayoutManager;

public class LayoutManagerMapping
implements LayoutManagerMaker {
    protected static Log log = LogFactory.getLog((Class)(class$org$apache$fop$layoutmgr$LayoutManagerMapping == null ? (class$org$apache$fop$layoutmgr$LayoutManagerMapping = LayoutManagerMapping.class$("org.apache.fop.layoutmgr.LayoutManagerMapping")) : class$org$apache$fop$layoutmgr$LayoutManagerMapping));
    private Map makers = new HashMap();
    static /* synthetic */ Class class$org$apache$fop$layoutmgr$LayoutManagerMapping;
    static /* synthetic */ Class class$org$apache$fop$fo$FOText;
    static /* synthetic */ Class class$org$apache$fop$fo$FObjMixed;
    static /* synthetic */ Class class$org$apache$fop$fo$flow$BidiOverride;
    static /* synthetic */ Class class$org$apache$fop$fo$flow$Inline;
    static /* synthetic */ Class class$org$apache$fop$fo$flow$Footnote;
    static /* synthetic */ Class class$org$apache$fop$fo$flow$InlineContainer;
    static /* synthetic */ Class class$org$apache$fop$fo$flow$BasicLink;
    static /* synthetic */ Class class$org$apache$fop$fo$flow$Block;
    static /* synthetic */ Class class$org$apache$fop$fo$flow$Leader;
    static /* synthetic */ Class class$org$apache$fop$fo$flow$RetrieveMarker;
    static /* synthetic */ Class class$org$apache$fop$fo$flow$Character;
    static /* synthetic */ Class class$org$apache$fop$fo$flow$ExternalGraphic;
    static /* synthetic */ Class class$org$apache$fop$fo$flow$BlockContainer;
    static /* synthetic */ Class class$org$apache$fop$fo$flow$ListItem;
    static /* synthetic */ Class class$org$apache$fop$fo$flow$ListBlock;
    static /* synthetic */ Class class$org$apache$fop$fo$flow$InstreamForeignObject;
    static /* synthetic */ Class class$org$apache$fop$fo$flow$PageNumber;
    static /* synthetic */ Class class$org$apache$fop$fo$flow$PageNumberCitation;
    static /* synthetic */ Class class$org$apache$fop$fo$flow$PageNumberCitationLast;
    static /* synthetic */ Class class$org$apache$fop$fo$flow$Table;
    static /* synthetic */ Class class$org$apache$fop$fo$flow$TableBody;
    static /* synthetic */ Class class$org$apache$fop$fo$flow$TableColumn;
    static /* synthetic */ Class class$org$apache$fop$fo$flow$TableRow;
    static /* synthetic */ Class class$org$apache$fop$fo$flow$TableCell;
    static /* synthetic */ Class class$org$apache$fop$fo$flow$TableFooter;
    static /* synthetic */ Class class$org$apache$fop$fo$flow$TableHeader;
    static /* synthetic */ Class class$org$apache$fop$fo$flow$Wrapper;
    static /* synthetic */ Class class$org$apache$fop$fo$pagination$Title;

    public LayoutManagerMapping() {
        this.initialize();
    }

    protected void initialize() {
        this.makers.put(class$org$apache$fop$fo$FOText == null ? (class$org$apache$fop$fo$FOText = LayoutManagerMapping.class$("org.apache.fop.fo.FOText")) : class$org$apache$fop$fo$FOText, new FOTextLayoutManagerMaker());
        this.makers.put(class$org$apache$fop$fo$FObjMixed == null ? (class$org$apache$fop$fo$FObjMixed = LayoutManagerMapping.class$("org.apache.fop.fo.FObjMixed")) : class$org$apache$fop$fo$FObjMixed, new Maker());
        this.makers.put(class$org$apache$fop$fo$flow$BidiOverride == null ? (class$org$apache$fop$fo$flow$BidiOverride = LayoutManagerMapping.class$("org.apache.fop.fo.flow.BidiOverride")) : class$org$apache$fop$fo$flow$BidiOverride, new BidiOverrideLayoutManagerMaker());
        this.makers.put(class$org$apache$fop$fo$flow$Inline == null ? (class$org$apache$fop$fo$flow$Inline = LayoutManagerMapping.class$("org.apache.fop.fo.flow.Inline")) : class$org$apache$fop$fo$flow$Inline, new InlineLayoutManagerMaker());
        this.makers.put(class$org$apache$fop$fo$flow$Footnote == null ? (class$org$apache$fop$fo$flow$Footnote = LayoutManagerMapping.class$("org.apache.fop.fo.flow.Footnote")) : class$org$apache$fop$fo$flow$Footnote, new FootnodeLayoutManagerMaker());
        this.makers.put(class$org$apache$fop$fo$flow$InlineContainer == null ? (class$org$apache$fop$fo$flow$InlineContainer = LayoutManagerMapping.class$("org.apache.fop.fo.flow.InlineContainer")) : class$org$apache$fop$fo$flow$InlineContainer, new InlineContainerLayoutManagerMaker());
        this.makers.put(class$org$apache$fop$fo$flow$BasicLink == null ? (class$org$apache$fop$fo$flow$BasicLink = LayoutManagerMapping.class$("org.apache.fop.fo.flow.BasicLink")) : class$org$apache$fop$fo$flow$BasicLink, new BasicLinkLayoutManagerMaker());
        this.makers.put(class$org$apache$fop$fo$flow$Block == null ? (class$org$apache$fop$fo$flow$Block = LayoutManagerMapping.class$("org.apache.fop.fo.flow.Block")) : class$org$apache$fop$fo$flow$Block, new BlockLayoutManagerMaker());
        this.makers.put(class$org$apache$fop$fo$flow$Leader == null ? (class$org$apache$fop$fo$flow$Leader = LayoutManagerMapping.class$("org.apache.fop.fo.flow.Leader")) : class$org$apache$fop$fo$flow$Leader, new LeaderLayoutManagerMaker());
        this.makers.put(class$org$apache$fop$fo$flow$RetrieveMarker == null ? (class$org$apache$fop$fo$flow$RetrieveMarker = LayoutManagerMapping.class$("org.apache.fop.fo.flow.RetrieveMarker")) : class$org$apache$fop$fo$flow$RetrieveMarker, new RetrieveMarkerLayoutManagerMaker());
        this.makers.put(class$org$apache$fop$fo$flow$Character == null ? (class$org$apache$fop$fo$flow$Character = LayoutManagerMapping.class$("org.apache.fop.fo.flow.Character")) : class$org$apache$fop$fo$flow$Character, new CharacterLayoutManagerMaker());
        this.makers.put(class$org$apache$fop$fo$flow$ExternalGraphic == null ? (class$org$apache$fop$fo$flow$ExternalGraphic = LayoutManagerMapping.class$("org.apache.fop.fo.flow.ExternalGraphic")) : class$org$apache$fop$fo$flow$ExternalGraphic, new ExternalGraphicLayoutManagerMaker());
        this.makers.put(class$org$apache$fop$fo$flow$BlockContainer == null ? (class$org$apache$fop$fo$flow$BlockContainer = LayoutManagerMapping.class$("org.apache.fop.fo.flow.BlockContainer")) : class$org$apache$fop$fo$flow$BlockContainer, new BlockContainerLayoutManagerMaker());
        this.makers.put(class$org$apache$fop$fo$flow$ListItem == null ? (class$org$apache$fop$fo$flow$ListItem = LayoutManagerMapping.class$("org.apache.fop.fo.flow.ListItem")) : class$org$apache$fop$fo$flow$ListItem, new ListItemLayoutManagerMaker());
        this.makers.put(class$org$apache$fop$fo$flow$ListBlock == null ? (class$org$apache$fop$fo$flow$ListBlock = LayoutManagerMapping.class$("org.apache.fop.fo.flow.ListBlock")) : class$org$apache$fop$fo$flow$ListBlock, new ListBlockLayoutManagerMaker());
        this.makers.put(class$org$apache$fop$fo$flow$InstreamForeignObject == null ? (class$org$apache$fop$fo$flow$InstreamForeignObject = LayoutManagerMapping.class$("org.apache.fop.fo.flow.InstreamForeignObject")) : class$org$apache$fop$fo$flow$InstreamForeignObject, new InstreamForeignObjectLayoutManagerMaker());
        this.makers.put(class$org$apache$fop$fo$flow$PageNumber == null ? (class$org$apache$fop$fo$flow$PageNumber = LayoutManagerMapping.class$("org.apache.fop.fo.flow.PageNumber")) : class$org$apache$fop$fo$flow$PageNumber, new PageNumberLayoutManagerMaker());
        this.makers.put(class$org$apache$fop$fo$flow$PageNumberCitation == null ? (class$org$apache$fop$fo$flow$PageNumberCitation = LayoutManagerMapping.class$("org.apache.fop.fo.flow.PageNumberCitation")) : class$org$apache$fop$fo$flow$PageNumberCitation, new PageNumberCitationLayoutManagerMaker());
        this.makers.put(class$org$apache$fop$fo$flow$PageNumberCitationLast == null ? (class$org$apache$fop$fo$flow$PageNumberCitationLast = LayoutManagerMapping.class$("org.apache.fop.fo.flow.PageNumberCitationLast")) : class$org$apache$fop$fo$flow$PageNumberCitationLast, new PageNumberCitationLastLayoutManagerMaker());
        this.makers.put(class$org$apache$fop$fo$flow$Table == null ? (class$org$apache$fop$fo$flow$Table = LayoutManagerMapping.class$("org.apache.fop.fo.flow.Table")) : class$org$apache$fop$fo$flow$Table, new TableLayoutManagerMaker());
        this.makers.put(class$org$apache$fop$fo$flow$TableBody == null ? (class$org$apache$fop$fo$flow$TableBody = LayoutManagerMapping.class$("org.apache.fop.fo.flow.TableBody")) : class$org$apache$fop$fo$flow$TableBody, new Maker());
        this.makers.put(class$org$apache$fop$fo$flow$TableColumn == null ? (class$org$apache$fop$fo$flow$TableColumn = LayoutManagerMapping.class$("org.apache.fop.fo.flow.TableColumn")) : class$org$apache$fop$fo$flow$TableColumn, new Maker());
        this.makers.put(class$org$apache$fop$fo$flow$TableRow == null ? (class$org$apache$fop$fo$flow$TableRow = LayoutManagerMapping.class$("org.apache.fop.fo.flow.TableRow")) : class$org$apache$fop$fo$flow$TableRow, new Maker());
        this.makers.put(class$org$apache$fop$fo$flow$TableCell == null ? (class$org$apache$fop$fo$flow$TableCell = LayoutManagerMapping.class$("org.apache.fop.fo.flow.TableCell")) : class$org$apache$fop$fo$flow$TableCell, new Maker());
        this.makers.put(class$org$apache$fop$fo$flow$TableFooter == null ? (class$org$apache$fop$fo$flow$TableFooter = LayoutManagerMapping.class$("org.apache.fop.fo.flow.TableFooter")) : class$org$apache$fop$fo$flow$TableFooter, new Maker());
        this.makers.put(class$org$apache$fop$fo$flow$TableHeader == null ? (class$org$apache$fop$fo$flow$TableHeader = LayoutManagerMapping.class$("org.apache.fop.fo.flow.TableHeader")) : class$org$apache$fop$fo$flow$TableHeader, new Maker());
        this.makers.put(class$org$apache$fop$fo$flow$Wrapper == null ? (class$org$apache$fop$fo$flow$Wrapper = LayoutManagerMapping.class$("org.apache.fop.fo.flow.Wrapper")) : class$org$apache$fop$fo$flow$Wrapper, new WrapperLayoutManagerMaker());
        this.makers.put(class$org$apache$fop$fo$pagination$Title == null ? (class$org$apache$fop$fo$pagination$Title = LayoutManagerMapping.class$("org.apache.fop.fo.pagination.Title")) : class$org$apache$fop$fo$pagination$Title, new InlineLayoutManagerMaker());
    }

    public void makeLayoutManagers(FONode node, List lms) {
        Maker maker = (Maker)this.makers.get(node.getClass());
        if (maker == null) {
            if ("http://www.w3.org/1999/XSL/Format".equals(node.getNamespaceURI())) {
                log.error((Object)("No LayoutManager maker for class " + node.getClass()));
            } else if (log.isDebugEnabled()) {
                log.debug((Object)("Skipping the creation of a layout manager for " + node.getClass()));
            }
        } else {
            maker.make(node, lms);
        }
    }

    public LayoutManager makeLayoutManager(FONode node) {
        ArrayList lms = new ArrayList();
        this.makeLayoutManagers(node, lms);
        if (lms.size() == 0) {
            throw new IllegalStateException("LayoutManager for class " + node.getClass() + " is missing.");
        }
        if (lms.size() > 1) {
            throw new IllegalStateException("Duplicate LayoutManagers for class " + node.getClass() + " found, only one may be declared.");
        }
        return (LayoutManager)lms.get(0);
    }

    public PageSequenceLayoutManager makePageSequenceLayoutManager(AreaTreeHandler ath, PageSequence ps) {
        return new PageSequenceLayoutManager(ath, ps);
    }

    public FlowLayoutManager makeFlowLayoutManager(PageSequenceLayoutManager pslm, Flow flow) {
        return new FlowLayoutManager(pslm, flow);
    }

    public ContentLayoutManager makeContentLayoutManager(PageSequenceLayoutManager pslm, Title title) {
        return new ContentLayoutManager(pslm, title);
    }

    public StaticContentLayoutManager makeStaticContentLayoutManager(PageSequenceLayoutManager pslm, StaticContent sc, SideRegion reg) {
        return new StaticContentLayoutManager(pslm, sc, reg);
    }

    public StaticContentLayoutManager makeStaticContentLayoutManager(PageSequenceLayoutManager pslm, StaticContent sc, Block block) {
        return new StaticContentLayoutManager(pslm, sc, block);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public class WrapperLayoutManagerMaker
    extends Maker {
        public void make(FONode node, List lms) {
            lms.add(new WrapperLayoutManager((Wrapper)node));
            ListIterator baseIter = node.getChildNodes();
            if (baseIter == null) {
                return;
            }
            while (baseIter.hasNext()) {
                FONode child = (FONode)baseIter.next();
                LayoutManagerMapping.this.makeLayoutManagers(child, lms);
            }
        }
    }

    public class RetrieveMarkerLayoutManagerMaker
    extends Maker {
        public void make(FONode node, List lms) {
            ListIterator baseIter = node.getChildNodes();
            if (baseIter == null) {
                return;
            }
            while (baseIter.hasNext()) {
                FONode child = (FONode)baseIter.next();
                LayoutManagerMapping.this.makeLayoutManagers(child, lms);
            }
        }
    }

    public static class TableLayoutManagerMaker
    extends Maker {
        public void make(FONode node, List lms) {
            Table table = (Table)node;
            TableLayoutManager tlm = new TableLayoutManager(table);
            lms.add(tlm);
        }
    }

    public static class PageNumberCitationLastLayoutManagerMaker
    extends Maker {
        public void make(FONode node, List lms) {
            lms.add(new PageNumberCitationLastLayoutManager((PageNumberCitationLast)node));
        }
    }

    public static class PageNumberCitationLayoutManagerMaker
    extends Maker {
        public void make(FONode node, List lms) {
            lms.add(new PageNumberCitationLayoutManager((PageNumberCitation)node));
        }
    }

    public static class PageNumberLayoutManagerMaker
    extends Maker {
        public void make(FONode node, List lms) {
            lms.add(new PageNumberLayoutManager((PageNumber)node));
        }
    }

    public static class InstreamForeignObjectLayoutManagerMaker
    extends Maker {
        public void make(FONode node, List lms) {
            lms.add(new InstreamForeignObjectLM((InstreamForeignObject)node));
        }
    }

    public static class ListBlockLayoutManagerMaker
    extends Maker {
        public void make(FONode node, List lms) {
            lms.add(new ListBlockLayoutManager((ListBlock)node));
        }
    }

    public static class ListItemLayoutManagerMaker
    extends Maker {
        public void make(FONode node, List lms) {
            lms.add(new ListItemLayoutManager((ListItem)node));
        }
    }

    public static class BlockContainerLayoutManagerMaker
    extends Maker {
        public void make(FONode node, List lms) {
            lms.add(new BlockContainerLayoutManager((BlockContainer)node));
        }
    }

    public static class ExternalGraphicLayoutManagerMaker
    extends Maker {
        public void make(FONode node, List lms) {
            ExternalGraphic eg = (ExternalGraphic)node;
            if (!eg.getSrc().equals("")) {
                lms.add(new ExternalGraphicLayoutManager(eg));
            }
        }
    }

    public static class CharacterLayoutManagerMaker
    extends Maker {
        public void make(FONode node, List lms) {
            Character foCharacter = (Character)node;
            if (foCharacter.getCharacter() != '\u0000') {
                lms.add(new CharacterLayoutManager(foCharacter));
            }
        }
    }

    public static class LeaderLayoutManagerMaker
    extends Maker {
        public void make(FONode node, List lms) {
            lms.add(new LeaderLayoutManager((Leader)node));
        }
    }

    public static class BlockLayoutManagerMaker
    extends Maker {
        public void make(FONode node, List lms) {
            lms.add(new BlockLayoutManager((org.apache.fop.fo.flow.Block)node));
        }
    }

    public static class BasicLinkLayoutManagerMaker
    extends Maker {
        public void make(FONode node, List lms) {
            lms.add(new BasicLinkLayoutManager((BasicLink)node));
        }
    }

    public static class InlineContainerLayoutManagerMaker
    extends Maker {
        public void make(FONode node, List lms) {
            ArrayList childList = new ArrayList();
            super.make(node, childList);
            lms.add(new ICLayoutManager((InlineContainer)node, childList));
        }
    }

    public static class FootnodeLayoutManagerMaker
    extends Maker {
        public void make(FONode node, List lms) {
            lms.add(new FootnoteLayoutManager((Footnote)node));
        }
    }

    public static class InlineLayoutManagerMaker
    extends Maker {
        public void make(FONode node, List lms) {
            if (node.getChildNodes() != null) {
                lms.add(new InlineLayoutManager((InlineLevel)node));
            }
        }
    }

    public static class BidiOverrideLayoutManagerMaker
    extends Maker {
        public void make(BidiOverride node, List lms) {
            ArrayList childList = new ArrayList();
            super.make(node, childList);
            for (int count = childList.size() - 1; count >= 0; --count) {
                LayoutManager lm = (LayoutManager)childList.get(count);
                if (lm instanceof InlineLevelLayoutManager) {
                    BidiLayoutManager blm = new BidiLayoutManager(node, (InlineLayoutManager)lm);
                    lms.add(blm);
                    continue;
                }
                lms.add(lm);
            }
        }
    }

    public static class FOTextLayoutManagerMaker
    extends Maker {
        public void make(FONode node, List lms) {
            FOText foText = (FOText)node;
            if (foText.endIndex - foText.startIndex > 0) {
                lms.add(new TextLayoutManager(foText));
            }
        }
    }

    public static class Maker {
        public void make(FONode node, List lms) {
        }
    }
}

