/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.area;

import java.awt.Color;
import java.io.Serializable;
import org.apache.fop.image.FopImage;
import org.apache.fop.util.ColorUtil;

public class Trait
implements Serializable {
    public static final Integer INTERNAL_LINK = new Integer(1);
    public static final Integer EXTERNAL_LINK = new Integer(2);
    public static final Integer FONT = new Integer(3);
    public static final Integer FONT_SIZE = new Integer(4);
    public static final Integer COLOR = new Integer(7);
    public static final Integer PROD_ID = new Integer(8);
    public static final Integer BACKGROUND = new Integer(9);
    public static final Integer UNDERLINE = new Integer(10);
    public static final Integer OVERLINE = new Integer(11);
    public static final Integer LINETHROUGH = new Integer(12);
    public static final Integer BORDER_START = new Integer(15);
    public static final Integer BORDER_END = new Integer(16);
    public static final Integer BORDER_BEFORE = new Integer(17);
    public static final Integer BORDER_AFTER = new Integer(18);
    public static final Integer PADDING_START = new Integer(19);
    public static final Integer PADDING_END = new Integer(20);
    public static final Integer PADDING_BEFORE = new Integer(21);
    public static final Integer PADDING_AFTER = new Integer(22);
    public static final Integer SPACE_START = new Integer(23);
    public static final Integer SPACE_END = new Integer(24);
    public static final Integer START_INDENT = new Integer(27);
    public static final Integer END_INDENT = new Integer(28);
    public static final Integer SPACE_BEFORE = new Integer(29);
    public static final Integer SPACE_AFTER = new Integer(30);
    public static final Integer IS_REFERENCE_AREA = new Integer(31);
    public static final Integer IS_VIEWPORT_AREA = new Integer(32);
    public static final Integer BLINK = new Integer(33);
    public static final Integer UNDERLINE_COLOR = new Integer(34);
    public static final Integer OVERLINE_COLOR = new Integer(35);
    public static final Integer LINETHROUGH_COLOR = new Integer(36);
    public static final int MAX_TRAIT_KEY = 36;
    private static final TraitInfo[] TRAIT_INFO = new TraitInfo[37];
    private Object propType;
    private Object data;
    static /* synthetic */ Class class$org$apache$fop$area$Trait$InternalLink;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$apache$fop$fonts$FontTriplet;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$awt$Color;
    static /* synthetic */ Class class$org$apache$fop$area$Trait$Background;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$org$apache$fop$traits$BorderProps;

    private static void put(Integer key, TraitInfo info) {
        Trait.TRAIT_INFO[key.intValue()] = info;
    }

    public static String getTraitName(Object traitCode) {
        return TRAIT_INFO[(Integer)traitCode].getName();
    }

    public static Class getTraitClass(Object traitCode) {
        return TRAIT_INFO[(Integer)traitCode].getClazz();
    }

    public Trait() {
        this.propType = null;
        this.data = null;
    }

    public Trait(Object propType, Object data) {
        this.propType = propType;
        this.data = data;
    }

    public Object getData() {
        return this.data;
    }

    public Object getPropType() {
        return this.propType;
    }

    public String toString() {
        return this.data.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        Trait.put(INTERNAL_LINK, new TraitInfo("internal-link", class$org$apache$fop$area$Trait$InternalLink == null ? (class$org$apache$fop$area$Trait$InternalLink = Trait.class$("org.apache.fop.area.Trait$InternalLink")) : class$org$apache$fop$area$Trait$InternalLink));
        Trait.put(EXTERNAL_LINK, new TraitInfo("external-link", class$java$lang$String == null ? (class$java$lang$String = Trait.class$("java.lang.String")) : class$java$lang$String));
        Trait.put(FONT, new TraitInfo("font", class$org$apache$fop$fonts$FontTriplet == null ? (class$org$apache$fop$fonts$FontTriplet = Trait.class$("org.apache.fop.fonts.FontTriplet")) : class$org$apache$fop$fonts$FontTriplet));
        Trait.put(FONT_SIZE, new TraitInfo("font-size", class$java$lang$Integer == null ? (class$java$lang$Integer = Trait.class$("java.lang.Integer")) : class$java$lang$Integer));
        Trait.put(COLOR, new TraitInfo("color", class$java$awt$Color == null ? (class$java$awt$Color = Trait.class$("java.awt.Color")) : class$java$awt$Color));
        Trait.put(PROD_ID, new TraitInfo("prod-id", class$java$lang$String == null ? (class$java$lang$String = Trait.class$("java.lang.String")) : class$java$lang$String));
        Trait.put(BACKGROUND, new TraitInfo("background", class$org$apache$fop$area$Trait$Background == null ? (class$org$apache$fop$area$Trait$Background = Trait.class$("org.apache.fop.area.Trait$Background")) : class$org$apache$fop$area$Trait$Background));
        Trait.put(UNDERLINE, new TraitInfo("underline-score", class$java$lang$Boolean == null ? (class$java$lang$Boolean = Trait.class$("java.lang.Boolean")) : class$java$lang$Boolean));
        Trait.put(UNDERLINE_COLOR, new TraitInfo("underline-score-color", class$java$awt$Color == null ? (class$java$awt$Color = Trait.class$("java.awt.Color")) : class$java$awt$Color));
        Trait.put(OVERLINE, new TraitInfo("overline-score", class$java$lang$Boolean == null ? (class$java$lang$Boolean = Trait.class$("java.lang.Boolean")) : class$java$lang$Boolean));
        Trait.put(OVERLINE_COLOR, new TraitInfo("overline-score-color", class$java$awt$Color == null ? (class$java$awt$Color = Trait.class$("java.awt.Color")) : class$java$awt$Color));
        Trait.put(LINETHROUGH, new TraitInfo("through-score", class$java$lang$Boolean == null ? (class$java$lang$Boolean = Trait.class$("java.lang.Boolean")) : class$java$lang$Boolean));
        Trait.put(LINETHROUGH_COLOR, new TraitInfo("through-score-color", class$java$awt$Color == null ? (class$java$awt$Color = Trait.class$("java.awt.Color")) : class$java$awt$Color));
        Trait.put(BLINK, new TraitInfo("blink", class$java$lang$Boolean == null ? (class$java$lang$Boolean = Trait.class$("java.lang.Boolean")) : class$java$lang$Boolean));
        Trait.put(BORDER_START, new TraitInfo("border-start", class$org$apache$fop$traits$BorderProps == null ? (class$org$apache$fop$traits$BorderProps = Trait.class$("org.apache.fop.traits.BorderProps")) : class$org$apache$fop$traits$BorderProps));
        Trait.put(BORDER_END, new TraitInfo("border-end", class$org$apache$fop$traits$BorderProps == null ? (class$org$apache$fop$traits$BorderProps = Trait.class$("org.apache.fop.traits.BorderProps")) : class$org$apache$fop$traits$BorderProps));
        Trait.put(BORDER_BEFORE, new TraitInfo("border-before", class$org$apache$fop$traits$BorderProps == null ? (class$org$apache$fop$traits$BorderProps = Trait.class$("org.apache.fop.traits.BorderProps")) : class$org$apache$fop$traits$BorderProps));
        Trait.put(BORDER_AFTER, new TraitInfo("border-after", class$org$apache$fop$traits$BorderProps == null ? (class$org$apache$fop$traits$BorderProps = Trait.class$("org.apache.fop.traits.BorderProps")) : class$org$apache$fop$traits$BorderProps));
        Trait.put(PADDING_START, new TraitInfo("padding-start", class$java$lang$Integer == null ? (class$java$lang$Integer = Trait.class$("java.lang.Integer")) : class$java$lang$Integer));
        Trait.put(PADDING_END, new TraitInfo("padding-end", class$java$lang$Integer == null ? (class$java$lang$Integer = Trait.class$("java.lang.Integer")) : class$java$lang$Integer));
        Trait.put(PADDING_BEFORE, new TraitInfo("padding-before", class$java$lang$Integer == null ? (class$java$lang$Integer = Trait.class$("java.lang.Integer")) : class$java$lang$Integer));
        Trait.put(PADDING_AFTER, new TraitInfo("padding-after", class$java$lang$Integer == null ? (class$java$lang$Integer = Trait.class$("java.lang.Integer")) : class$java$lang$Integer));
        Trait.put(SPACE_START, new TraitInfo("space-start", class$java$lang$Integer == null ? (class$java$lang$Integer = Trait.class$("java.lang.Integer")) : class$java$lang$Integer));
        Trait.put(SPACE_END, new TraitInfo("space-end", class$java$lang$Integer == null ? (class$java$lang$Integer = Trait.class$("java.lang.Integer")) : class$java$lang$Integer));
        Trait.put(START_INDENT, new TraitInfo("start-indent", class$java$lang$Integer == null ? (class$java$lang$Integer = Trait.class$("java.lang.Integer")) : class$java$lang$Integer));
        Trait.put(END_INDENT, new TraitInfo("end-indent", class$java$lang$Integer == null ? (class$java$lang$Integer = Trait.class$("java.lang.Integer")) : class$java$lang$Integer));
        Trait.put(SPACE_BEFORE, new TraitInfo("space-before", class$java$lang$Integer == null ? (class$java$lang$Integer = Trait.class$("java.lang.Integer")) : class$java$lang$Integer));
        Trait.put(SPACE_AFTER, new TraitInfo("space-after", class$java$lang$Integer == null ? (class$java$lang$Integer = Trait.class$("java.lang.Integer")) : class$java$lang$Integer));
        Trait.put(IS_REFERENCE_AREA, new TraitInfo("is-reference-area", class$java$lang$Boolean == null ? (class$java$lang$Boolean = Trait.class$("java.lang.Boolean")) : class$java$lang$Boolean));
        Trait.put(IS_VIEWPORT_AREA, new TraitInfo("is-viewport-area", class$java$lang$Boolean == null ? (class$java$lang$Boolean = Trait.class$("java.lang.Boolean")) : class$java$lang$Boolean));
    }

    public static class Background
    implements Serializable {
        private Color color = null;
        private String url = null;
        private FopImage fopimage = null;
        private int repeat;
        private int horiz;
        private int vertical;

        public Color getColor() {
            return this.color;
        }

        public int getHoriz() {
            return this.horiz;
        }

        public int getRepeat() {
            return this.repeat;
        }

        public String getURL() {
            return this.url;
        }

        public FopImage getFopImage() {
            return this.fopimage;
        }

        public int getVertical() {
            return this.vertical;
        }

        public void setColor(Color color) {
            this.color = color;
        }

        public void setHoriz(int horiz) {
            this.horiz = horiz;
        }

        public void setRepeat(int repeat) {
            this.repeat = repeat;
        }

        public void setRepeat(String repeat) {
            this.setRepeat(Background.getConstantForRepeat(repeat));
        }

        public void setURL(String url) {
            this.url = url;
        }

        public void setFopImage(FopImage fopimage) {
            this.fopimage = fopimage;
        }

        public void setVertical(int vertical) {
            this.vertical = vertical;
        }

        private String getRepeatString() {
            switch (this.getRepeat()) {
                case 112: {
                    return "repeat";
                }
                case 113: {
                    return "repeat-x";
                }
                case 114: {
                    return "repeat-y";
                }
                case 96: {
                    return "no-repeat";
                }
            }
            throw new IllegalStateException("Illegal repeat style: " + this.getRepeat());
        }

        private static int getConstantForRepeat(String repeat) {
            if ("repeat".equalsIgnoreCase(repeat)) {
                return 112;
            }
            if ("repeat-x".equalsIgnoreCase(repeat)) {
                return 113;
            }
            if ("repeat-y".equalsIgnoreCase(repeat)) {
                return 114;
            }
            if ("no-repeat".equalsIgnoreCase(repeat)) {
                return 96;
            }
            throw new IllegalStateException("Illegal repeat style: " + repeat);
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            if (this.color != null) {
                sb.append("color=").append(ColorUtil.colorToString(this.color));
            }
            if (this.url != null) {
                if (this.color != null) {
                    sb.append(",");
                }
                sb.append("url=").append(this.url);
                sb.append(",repeat=").append(this.getRepeatString());
                sb.append(",horiz=").append(this.horiz);
                sb.append(",vertical=").append(this.vertical);
            }
            return sb.toString();
        }
    }

    public static class InternalLink
    implements Serializable {
        private String pvKey;
        private String idRef;

        public InternalLink(String pvKey, String idRef) {
            this.setPVKey(pvKey);
            this.setIDRef(idRef);
        }

        public InternalLink(String attrValue) {
            String[] values = InternalLink.parseXMLAttribute(attrValue);
            this.setPVKey(values[0]);
            this.setIDRef(values[1]);
        }

        public void setPVKey(String pvKey) {
            this.pvKey = pvKey;
        }

        public String getPVKey() {
            return this.pvKey;
        }

        public void setIDRef(String idRef) {
            this.idRef = idRef;
        }

        public String getIDRef() {
            return this.idRef;
        }

        public String xmlAttribute() {
            return InternalLink.makeXMLAttribute(this.pvKey, this.idRef);
        }

        public static String makeXMLAttribute(String pvKey, String idRef) {
            return "(" + (pvKey == null ? "" : pvKey) + "," + (idRef == null ? "" : idRef) + ")";
        }

        public static String[] parseXMLAttribute(String attrValue) {
            String[] result = new String[]{null, null};
            if (attrValue != null) {
                int len = attrValue.length();
                if (len >= 2 && attrValue.charAt(0) == '(' && attrValue.charAt(len - 1) == ')') {
                    String[] values = attrValue.substring(1, len - 1).split(",", 2);
                    if (values.length > 0) {
                        result[0] = values[0].trim();
                        if (values.length > 1) {
                            result[1] = values[1].trim();
                        }
                    }
                } else {
                    result[0] = attrValue;
                }
            }
            return result;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("pvKey=").append(this.pvKey);
            sb.append(",idRef=").append(this.idRef);
            return sb.toString();
        }
    }

    private static class TraitInfo {
        private String name;
        private Class clazz;

        public TraitInfo(String name, Class clazz) {
            this.name = name;
            this.clazz = clazz;
        }

        public String getName() {
            return this.name;
        }

        public Class getClazz() {
            return this.clazz;
        }
    }
}

