/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.apps;

import java.io.File;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.Version;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.FopFactory;
import org.apache.fop.fo.FOEventHandler;
import org.apache.fop.pdf.PDFEncryptionParams;
import org.apache.fop.render.Renderer;
import org.apache.fop.render.RendererFactory;
import org.apache.fop.render.XMLHandlerRegistry;

public class FOUserAgent {
    public static final float DEFAULT_TARGET_RESOLUTION = 72.0f;
    private static Log log = LogFactory.getLog((String)"FOP");
    private FopFactory factory;
    private String baseURL;
    private URIResolver uriResolver = null;
    private float targetResolution = 72.0f;
    private Map rendererOptions = new HashMap();
    private File outputFile = null;
    private Renderer rendererOverride = null;
    private FOEventHandler foEventHandlerOverride = null;
    protected String producer = "Apache FOP Version " + Version.getVersion();
    protected String creator = null;
    protected Date creationDate = null;
    protected String author = null;
    protected String title = null;
    protected String keywords = null;

    public FOUserAgent() throws FOPException {
        this(FopFactory.newInstance());
    }

    public FOUserAgent(FopFactory factory) {
        if (factory == null) {
            throw new NullPointerException("The factory parameter must not be null");
        }
        this.factory = factory;
        this.setBaseURL(factory.getBaseURL());
        this.setTargetResolution(factory.getTargetResolution());
    }

    public FopFactory getFactory() {
        return this.factory;
    }

    public void setRendererOverride(Renderer renderer) {
        this.rendererOverride = renderer;
    }

    public Renderer getRendererOverride() {
        return this.rendererOverride;
    }

    public void setFOEventHandlerOverride(FOEventHandler handler) {
        this.foEventHandlerOverride = handler;
    }

    public FOEventHandler getFOEventHandlerOverride() {
        return this.foEventHandlerOverride;
    }

    public void setProducer(String producer) {
        this.producer = producer;
    }

    public String getProducer() {
        return this.producer;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public String getCreator() {
        return this.creator;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public String getAuthor() {
        return this.author;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    public void setKeywords(String keywords) {
        this.keywords = keywords;
    }

    public String getKeywords() {
        return this.keywords;
    }

    public Map getRendererOptions() {
        return this.rendererOptions;
    }

    public void setBaseURL(String baseURL) {
        this.baseURL = baseURL;
    }

    public String getBaseURL() {
        return this.baseURL;
    }

    public void setURIResolver(URIResolver resolver) {
        this.uriResolver = resolver;
    }

    public URIResolver getURIResolver() {
        return this.uriResolver;
    }

    public PDFEncryptionParams getPDFEncryptionParams() {
        return (PDFEncryptionParams)this.getRendererOptions().get("encryption-params");
    }

    public void setPDFEncryptionParams(PDFEncryptionParams pdfEncryptionParams) {
        this.getRendererOptions().put("encryption-params", pdfEncryptionParams);
    }

    public Source resolveURI(String uri) {
        return this.resolveURI(uri, this.getBaseURL());
    }

    public Source resolveURI(String uri, String base) {
        Source source = null;
        boolean bypassURIResolution = uri.startsWith("data:");
        if (!bypassURIResolution && this.uriResolver != null) {
            try {
                source = this.uriResolver.resolve(uri, base);
            }
            catch (TransformerException te) {
                log.error((Object)("Attempt to resolve URI '" + uri + "' failed: "), (Throwable)te);
            }
        }
        if (source == null) {
            source = this.getFactory().resolveURI(uri, base);
        }
        return source;
    }

    public void setOutputFile(File f) {
        this.outputFile = f;
    }

    public File getOutputFile() {
        return this.outputFile;
    }

    public float getTargetPixelUnitToMillimeter() {
        return 25.4f / this.targetResolution;
    }

    public float getTargetResolution() {
        return this.targetResolution;
    }

    public void setTargetResolution(float dpi) {
        this.targetResolution = dpi;
        log.info((Object)("target-resolution set to: " + this.targetResolution + "dpi (px2mm=" + this.getTargetPixelUnitToMillimeter() + ")"));
    }

    public void setTargetResolution(int dpi) {
        this.setTargetResolution((float)dpi);
    }

    public String getFontBaseURL() {
        String fontBaseURL = this.getFactory().getFontBaseURL();
        return fontBaseURL != null ? fontBaseURL : this.getBaseURL();
    }

    public float getSourcePixelUnitToMillimeter() {
        return this.getFactory().getSourcePixelUnitToMillimeter();
    }

    public float getSourceResolution() {
        return this.getFactory().getSourceResolution();
    }

    public String getPageHeight() {
        return this.getFactory().getPageHeight();
    }

    public String getPageWidth() {
        return this.getFactory().getPageWidth();
    }

    public boolean validateStrictly() {
        return this.getFactory().validateStrictly();
    }

    public boolean isBreakIndentInheritanceOnReferenceAreaBoundary() {
        return this.getFactory().isBreakIndentInheritanceOnReferenceAreaBoundary();
    }

    public RendererFactory getRendererFactory() {
        return this.getFactory().getRendererFactory();
    }

    public XMLHandlerRegistry getXMLHandlerRegistry() {
        return this.getFactory().getXMLHandlerRegistry();
    }
}

