/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.apps;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlgraphics.util.io.Base64DecodeStream;
import org.apache.xmlgraphics.util.io.Base64EncodeStream;

public class FOURIResolver
implements URIResolver {
    private Log log = LogFactory.getLog((String)"FOP");

    public Source resolve(String href, String base) throws TransformerException {
        if (href.startsWith("data:")) {
            return this.parseDataURI(href);
        }
        URL absoluteURL = null;
        File f = new File(href);
        if (f.exists()) {
            try {
                absoluteURL = f.toURL();
            }
            catch (MalformedURLException mfue) {
                this.log.error((Object)("Could not convert filename to URL: " + mfue.getMessage()));
            }
        } else {
            URL baseURL = null;
            try {
                baseURL = this.toBaseURL(base);
            }
            catch (MalformedURLException mfue) {
                this.log.error((Object)("Error with base URL \"" + base + "\"): " + mfue.getMessage()));
            }
            if (baseURL == null) {
                try {
                    absoluteURL = new URL(href);
                }
                catch (MalformedURLException mue) {
                    try {
                        absoluteURL = new URL("file:" + href);
                    }
                    catch (MalformedURLException mfue) {
                        this.log.error((Object)("Error with URL '" + href + "': " + mue.getMessage()));
                        return null;
                    }
                }
            } else {
                try {
                    String scheme = baseURL.getProtocol() + ":";
                    if (href.startsWith(scheme)) {
                        href = href.substring(scheme.length());
                        if ("file:".equals(scheme)) {
                            int colonPos = href.indexOf(58);
                            int slashPos = href.indexOf(47);
                            if (slashPos >= 0 && colonPos >= 0 && colonPos < slashPos) {
                                href = "/" + href;
                            }
                        }
                    }
                    absoluteURL = new URL(baseURL, href);
                }
                catch (MalformedURLException mfue) {
                    this.log.error((Object)("Error with URL '" + href + "': " + mfue.getMessage()));
                    return null;
                }
            }
        }
        String effURL = absoluteURL.toExternalForm();
        try {
            URLConnection connection = absoluteURL.openConnection();
            connection.setAllowUserInteraction(false);
            connection.setDoInput(true);
            this.updateURLConnection(connection, href);
            connection.connect();
            return new StreamSource(connection.getInputStream(), effURL);
        }
        catch (FileNotFoundException fnfe) {
            this.log.debug((Object)("File not found: " + effURL));
        }
        catch (IOException ioe) {
            this.log.error((Object)("Error with opening URL '" + effURL + "': " + ioe.getMessage()));
        }
        return null;
    }

    protected void updateURLConnection(URLConnection connection, String href) {
    }

    protected void applyHttpBasicAuthentication(URLConnection connection, String username, String password) {
        String combined = username + ":" + password;
        try {
            ByteArrayOutputStream baout = new ByteArrayOutputStream(combined.length() * 2);
            Base64EncodeStream base64 = new Base64EncodeStream((OutputStream)baout);
            base64.write(combined.getBytes());
            base64.close();
            connection.setRequestProperty("Authorization", "Basic " + new String(baout.toByteArray()));
        }
        catch (IOException e) {
            throw new RuntimeException("Error during base64 encodation of username/password");
        }
    }

    private URL toBaseURL(String base) throws MalformedURLException {
        if (base == null) {
            return new File("").toURL();
        }
        if (!base.endsWith("/")) {
            base = base + "/";
        }
        return new URL(base);
    }

    private Source parseDataURI(String href) {
        int commaPos = href.indexOf(44);
        String header = href.substring(0, commaPos);
        String data = href.substring(commaPos + 1);
        if (header.endsWith(";base64")) {
            byte[] bytes = data.getBytes();
            ByteArrayInputStream encodedStream = new ByteArrayInputStream(bytes);
            Base64DecodeStream decodedStream = new Base64DecodeStream((InputStream)encodedStream);
            return new StreamSource((InputStream)decodedStream);
        }
        return new StreamSource(new StringReader(data));
    }
}

